<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>سند شراء</title>
    <style>
        .invoice-box {
            max-width: 800px;
            margin: auto;
            padding: 30px;
            border: 1px solid #eee;
            box-shadow: 0 0 10px rgb(0 0 0 / 15%);
            font-size: 17px;
            line-height: 20px;
            font-family: 'Cairo', sans-serif;
            color: #555;
            text-align: right;
        }

        .top {
            display: flex;
            flex-direction: row-reverse;
            align-content: center;
            justify-content: space-between;
            font-size: 20px;
            font-weight: bold;
            padding-bottom: 10;
            border-bottom: 4px solid #193B62;
        }

        .information {

            font-weight: 100;
            padding-bottom: 10px;
            border-bottom: none;
        }

        .top span:nth-child(1) {
            display: block;
        }
        .information .right {
            display: flex;
            flex-direction: column;
            align-content: center;
        }
        .top .right {
            display: flex;
            align-items: end;
            flex-direction: column;
            align-content: center;
        }

        .top .center {
            display: black;
            align-items: center;
        }
        .top .center p{
            text-align: center;
            text-decoration: underline;
            font-weight: 800;
            margin-bottom: 5px
        }

        .information {
            display: flex;
            flex-direction: row-reverse;
            align-content: center;
            justify-content: space-between;
            margin-top: 20px;
            padding-left: 50px;
            padding-right: 50px;
        }

        .information .right {
           
        }

        .information .center {
            display: flex;
            align-items: center;
            flex-direction: column;
            align-content: center;

        }

        .information .left {
        

        }

        .information-main {
            display: flex;
            flex-direction: row-reverse;
            align-content: center;
            justify-content: space-between;
            margin-top: 30px;
            padding-left: 90px;
            padding-right: 90px;
        }



        .information-main .right {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;
        }

        .information-main .left {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;

        }

        .left span:nth-child(1) {
            display: block;
        }

        .left span:nth-child(2) {
            display: block;
        }

        span {
            margin-right: 8px;
            font-weight: 500;
        }

        .bold {
            font-weight: bold;
        }

        .botom {
            display: flex;
            flex-direction: row-reverse;
            align-content: center;
            justify-content: space-between;
            margin-top: 40px;
            padding-left: 50px;
            padding-right: 50px;

        }



        .botom .right {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;
        }

        .botom .center {
            display: flex;
            align-items: center;
            flex-direction: column;
            align-content: center;

        }

        .botom .left {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;

        }

        .botom-seg {
            display: flex;
            flex-direction: row-reverse;
            align-content: center;
            justify-content: space-between;
            margin-top: 10px;
            padding-left: 50px;
            padding-right: 50px;
            margin-bottom: 40px;
        }



        .botom-seg .right {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;
        }

        .botom-seg .center {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;

        }

        .botom-seg .left {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;

        }

        @media print {
            .invoice-box {
                max-width: unset;
                box-shadow: none;
                border: 0px;
            }
        }

        @page {
            size: A5 landscape
        }
    </style>
</head>

<body>
    <div class="invoice-box">
        <div class="top">
            <div class="left">
                <span>الجمهورية اليمنية</span>
                <span>صنعاء  - الجراف</span>
                <span>+967 773344551</span>
            </div>
            <div class="center">
                <div><img width="200" src="<?php echo e(asset('/images/logo-full.png')); ?>" alt=""></div>
                <p>
                    سند استلام كمية
                </p>
            </div>
            <div class="right">

                <span class="">رقم السند :
                    <?php if(isset($recept->id)): ?>
                        <?php echo e($recept->id); ?>

                    <?php endif; ?>
                    </span>
                <span class="">رقم العملية :
                    <?php if(isset($buying->id)): ?>
                        <?php echo e($buying->id); ?>

                    <?php endif; ?>
                    </span>
                <span class="">
                    <span class="" id="hijri">
                    </span>
                    <span class="" id="milady">
                    </span>
            </div>

        </div>

        <div class="information">
            <div class="left bold">
                <span style="margin-top: 10px"> استلمت من الأخوة :  <strong>محطة حنيش </strong> </span>
                <span style="margin-top: 10px">النوع : <strong><?php echo e($fNTT::giveType($buying->type)); ?> </strong> </span>

            </div>
            <div class="center">
               
            </div>
            <div class="right">
                <span style="margin-top: 10px">كمية :<strong><?php echo e($buying->quantity); ?> </strong> لتر </span>          
                  </div>
            
                
            

        </div>
      

<div>

</div>
        <div class="botom">
            <div class="right">
                <span class="bold">: المستلم</span>
                <span>
                    <?php if(isset($buyerName)): ?>
                        <?php echo e($buyerName); ?>

                    <?php endif; ?>
                </span>
            </div>
            <div class="center" style="flex-direction: row-reverse;">
                <span class="bold">: المحاسب</span>
                <span>
                    <?php if(isset($accounterName)): ?>
                        <?php echo e($accounterName); ?>

                    <?php endif; ?>
                </span>
            </div>
            <div class="left">
                <span class="bold">: المدير</span>
                <span>
                    <?php if(isset($adminName)): ?>
                        <?php echo e($adminName); ?>

                    <?php endif; ?>
                </span>
            </div>
        </div>
        <div class="botom-seg">
            <div class="right">
                <span class="bold">: التوقيع</span>
                <span>........................</span>
            </div>
            <div class="center">
                <span class="bold">: التوقيع</span>
                <span>........................</span>
            </div>
            <div class="left">
                <span class="bold">: التوقيع</span>
                <span>........................</span>
            </div>
        </div>

    </div>

</body>
<script src="<?php echo e(asset('/js/date/hijri.js')); ?>"></script>



</html>
<?php /**PATH C:\Users\Nasser\Desktop\petrol_store\resources\views/buying/receipt.blade.php ENDPATH**/ ?>